/* BOLT Chooser -
	Tree Style Multiple Query Result Selector


	Given a list of queries, generate a tree view of the results 
	of those queries.  Allow the user to select one of them.

	Optionally, allow searching the table objects

	Optionally display a "New" Button

  */

//#include "wx/string.h"
#include "wx/treectrl.h"
#include "wx/checkbox.h"
#include "wx/listctrl.h"
//#include "ctrl/BOLTControls.h"
//#include "wx/dialog.h"
//#include "wx/bmpbuttn.h"
//#include "wx/panel.h"
class bcQueryList;

class BOLTChooser : public wxDialog {
//DECLARE_DYNAMIC_CLASS(BOLTChooser)
public:
	void handleQueryList(wxTreeEvent &event);
	void AddQuickPicks(const char* qpClass);
	BOLTChooser(BOLTdb *dbase,wxWindow* parent,wxWindowID id,long style = wxDEFAULT_DIALOG_STYLE);
	~BOLTChooser();
	bool AddQuery(wxString& name,wxString& query);
	bool AddQuery(const char *name,const char *query);
	bool SetSearchFields(wxString& table,wxArrayString& fields);
	bool ClearQueries();
	RECORD_ID GetChoice(bool allowNew=false,const char *newTable=NULL, bool allowSearch=false);
	RECORD_ID SearchChoice(const char *searchString);
	void OnActivate(wxTreeEvent& event);
	void OnBNew(wxCommandEvent& event);
	void OnBSearch(wxCommandEvent& event);
	void OnBOK(wxCommandEvent& event);
	void OnBCancel(wxCommandEvent& event);
virtual void Dump(ostream& stream) 
	{	stream << "Dump :BOLTChooser"; }

private:
	bool CreateControls();
		bool RunQueries();
	BOLTdb *db;
	wxArrayString queryNames;
	wxArrayString queryText;
	wxString table;
	wxArrayString searchFields;
	bcQueryList *treeCtrl;
	wxButton *bOk,*bCancel,*bNew,*bSearch;


	DECLARE_EVENT_TABLE()
};

class BOLTSearcher : public wxDialog {
//DECLARE_DYNAMIC_CLASS(BOLTSearcher)
public:
	wxString sOrderBy;
	void OnColumn(wxListEvent &event);
	BOLTSearcher(BOLTdb *dbase,wxWindow* parent,wxWindowID id,long style = wxDEFAULT_DIALOG_STYLE|wxTAB_TRAVERSAL|wxDIALOG_MODELESS);
	~BOLTSearcher();
	RECORD_ID GetChoice(wxString& table,wxArrayString& searchFields,const char *search="");
	void DoSearch();
	void OnActivate(wxListEvent& event);
	void OnBStart(wxCommandEvent& event);
	void OnBCancel(wxCommandEvent& event);
	void OnBOpen(wxCommandEvent& event);
	void OnCCase(wxCommandEvent& event);
	void OnCWhole(wxCommandEvent& event);
	void OnTSearch(wxCommandEvent& event);
	void OnChar(wxKeyEvent& event);
virtual void Dump(ostream& stream) 
	{	stream << "Dump : BOLTSearcher"; }

private:
	BOLTdb *db;
	wxString table;
	wxArrayString searchFields;
	wxTreeCtrl *treeCtrl;
	wxButton *bStart,*bCancel,*bOpen;
	wxCheckBox *cCase,*cWhole;
	wxListCtrl *lResults;
	wxTextCtrl *tSearch;
	bool cancelSearch;
	DECLARE_EVENT_TABLE()
};